{/* 
import Image from 'next/image'
import { useEffect, useRef, useState } from 'react'
import { useRouter } from 'next/router'
import { remark } from 'remark';
import html from 'remark-html';
import breaks from 'remark-breaks';

import Section from '@/fragments/section';
import Container from '@/fragments/container';
import BoxInvisible from '@/fragments/boxInvisible';

import api from '@/services/api';

import styles from './style.module.scss'

const SpecificNewsPage = () => {
  const [post, setPost] = useState<any>()
  const [related, setRelated] = useState<any[] | undefined>()

  const router = useRouter()
  const {slug} = router.query

  const contentHtml = useRef('')

  useEffect(() => {
    const getPost = async () => {
      try {
        const res = await api.get( `/noticias?filters[slug][$eq]=${slug}&populate[0]=imagem&populate[1]=noticias&populate[2]=noticias.imagem`)
       
        const {data, status } = res;

        const markdown = data.data[0].attributes.conteudo;

        const processedContent = await remark()
          .use(breaks)
          .use(html)
          .process(markdown);

        const postContentSerialized = addApiUrlOnTagImg(processedContent.toString()); 
        
        contentHtml.current = postContentSerialized;

        if (status !== 200) throw new Error()
        setPost(data.data[0])

      } catch (error) {
        console.log(error)
      }
    }
    if (slug) {
      getPost()
    }
  }, [slug])

  function renderImgUrl (relative_path: string) {
    const img_src = post && process.env.NEXT_PUBLIC_ENDPOINT + relative_path
    return img_src
  }

  function addApiUrlOnTagImg(string: string) {
    return string.replace(/<img\s+([^>]*?src=["'])(\/uploads\/[^"']*["'][^>]*>)/g, (match, p1, p2) => {
      return `<img ${p1}${process.env.NEXT_PUBLIC_ENDPOINT}${p2}`;
    });
  }

  return (
    <Section>
      <BoxInvisible size="normal" />
      <Container>
        <div className={styles.new_post_page_wrapper}>
          <main className={styles.main_new_post}>
            <div className={styles.post_image_container}>
              <Image src={renderImgUrl(post?.attributes?.imagem?.data?.attributes?.url)} alt="alt" width={941} height={659} style={{width: '100%', height: 'auto', objectFit: 'contain', borderRadius: '72px', overflow: 'hidden'}} />

            </div>
            <div className={styles.news_post_text}>
              <h1 className={styles.post_title}>{post?.attributes.titulo}</h1>
              <div className={styles.post_content} dangerouslySetInnerHTML={{ __html: contentHtml.current}} />
            </div>
          </main>

          {post?.attributes?.noticias?.data.length > 0 && (
            <aside>
              <h3>Veja também</h3>
              <div className={styles.related_news_list}>
                {post?.attributes?.noticias?.data.slice(0, 6).map((item: any) => (
                  <div key={item.id} className={styles.related_post} onClick={() => router.push(`${item.attributes.slug}`) }>
                    <div className={styles.related_post_img_container}>
                      <Image  src={renderImgUrl(item?.attributes?.imagem?.data?.attributes?.url)} alt='Imagem representando um novo artigo' width={208} height={210} style={{width: '100%', height: '100%', objectFit: 'contain', borderRadius: '32px', overflow: 'hidden'}} />
                    </div>
                    <div className={styles.related_news}>
                      <h5 >{item.attributes.titulo}</h5>
                      <p>{item.attributes.descricao}</p>
                    </div>
                  </div>
                ))}
              </div>
            </aside>
          )}
        </div>
      </Container>
    </Section>
  )
}

export default SpecificNewsPage
*/}

import { GetServerSideProps } from 'next'

export const getServerSideProps: GetServerSideProps = async () => {
  return {
    redirect: {
      destination: '/',
      permanent: false,
    },
  }
}

export default function SpecificNewsPage() {
  return null
}